% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate_shift.r
\name{locate_shift}
\alias{locate_shift}
\title{Interactive locating of range shifting}
\usage{
locate_shift(time, x, y, n.clust = 2, ...)
}
\arguments{
\item{time}{time (can be a \code{\link[base]{POSIXt}})}

\item{x}{x and y coordinates.  Can be two separate vectors OR a complex "x" OR a two-column matrix/date-frame.}

\item{y}{see x}

\item{n.clust}{number of ranges (either 2 or 3)}

\item{...}{additional parameters to pass to plot functions}
}
\value{
a named vector of initial estimates: 
if \code{n.clust = 2}, c(x1, x2, y1, y2, t1, dt) 
if \code{n.clust = 3}, c(x1, x2, x3, y1, y2, y3, t1, t2, dt1, dt2)
}
\description{
Plots an x-y, time-x, time-y track of a potential migration process and prompts the user to click on the figure to obtain initial estimates of range centroids and timing of start and end of migrations.
}
\seealso{
\code{\link{quickfit}}, code{\link{locator}}
}
