% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getArea.r
\name{getArea}
\alias{getArea}
\title{Compute area}
\usage{
getArea(p, T, X, Y, alpha = 0.95, model = c("wn", "ou", "ouf")[1],
  direct = NULL)
}
\arguments{
\item{p}{estimated mouf parameter vector (tau.z, tau.v, t1, dt, x1, y1, x2, y2)}

\item{T}{time}

\item{X}{x coordinate}

\item{Y}{y coordinate}

\item{alpha}{proportion of area used to be computed}

\item{model}{one of "wn", "ou", "ouf" - whether or not the velocity autocorrelation needs to be taken into account.}

\item{direct}{whether or not to compute the area directly (i.e. fitting a symmetric bivariate normal to the residuals) or to account for the autocorrelation.  The default behavior (NULL) computes directly for the "wn" model, and uses the autocorrelation (which is slower) only if the estmated spatial time scale is greater that 1/30 of the total time range.}
}
\description{
Compute predicted area at given alpha level (e.g. 50\% or 90\%) of a migration model fit
}
\details{
For sufficient data (i.e. where the range in the times is much greater than the ) This function estimates the (symmetric) 95\% area of use from a bivariate Gaussian
}
