% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{SimulatedTracks}
\alias{SimulatedTracks}
\alias{MOU.3range}
\alias{MOU.sim}
\alias{MOUF.sim}
\alias{MOUF.sim.random}
\alias{MWN.sim}
\title{Simulated range shift tracks}
\format{Each of these is a data frame with 100 observations of 
three numeric variables (except for MOU.3range, which has 200 observations).  
The columns are: \code{T}, \code{X}, \code{Y}.}
\source{
Code to simulate tracks like these are provided in the marcher vignette.
}
\usage{
data("SimulatedTracks")
}
\description{
Five simulated tracks: \code{MWN.sim},  \code{MOU.sim}, \code{MOUF.sim} are simulated two-range shifts with different levels of position and velocity autocorrelation, \code{MOUF.sim.random} which has 100 observations random times, and \code{MOU.3range} which is a MOU process with two range shifts (and 200 observations).
}
\details{
The data frames are also \code{track} class object frame.
\describe{
  \item{MOU.3range}{Simulated migratory Ornstein-Uhlenbeck with 3 range}
  \item{MOU.sim}{Simulated migratory Ornstein-Uhlenbeck}
  \item{MOUF.sim}{Simulated migratory Ornstein-Uhlenbeck Flemming}
  \item{MOUF.sim.random}{Simulated migratory Ornstein-Uhlenbeck Flemming at random or arbitrary times of observation}
  \item{MWN.sim}{Simulated migratory white noise ranging model}
  }
}
\examples{
data(SimulatedTracks)
scan_track(MWN.sim)
scan_track(MOU.sim)
scan_track(MOUF.sim)
scan_track(MOUF.sim.random)
scan_track(MOU.3range)
}
\keyword{data}
