% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-maps.R
\name{ms_generate_map}
\alias{ms_generate_map}
\title{Generate maps for 'mapscanner' use}
\usage{
ms_generate_map(
  bbox,
  max_tiles = 16L,
  mapname = NULL,
  bw = TRUE,
  style = "light",
  raster_brick = NULL
)
}
\arguments{
\item{bbox}{Either a string specifying the location, or a numeric bounding
box as a single vector of (xmin, ymin, xmax, ymax), or a 2-by-2 matrix with
columns of (min, max) and rows of (x, y), respectively.}

\item{max_tiles}{Maximum number of tiles to use to create map}

\item{mapname}{Name of map to be produced, optionally including full path.
Extension will be ignored.}

\item{bw}{If \code{FALSE}, print maps in colour, otherwise black-and-white. Note
that the default \code{style = "light"} is monochrome, and that this parameter
only has effect for \code{style} values of \code{"streets"} or \code{"outdoors"}.}

\item{style}{The style of the map to be generated; one of 'light', 'streets',
or 'outdoors', rendered in black and white. See
\url{https://docs.mapbox.com/api/maps/#styles/} for examples.}

\item{raster_brick}{Instead of automatically downloading tiles within a given
\code{bbox}, a pre-downloaded \code{raster::rasterBrick} object may be submitted and
used to generate the \code{.pdf} and \code{.png} equivalents.}
}
\value{
Invisibly returns a \code{rasterBrick} object from the \pkg{raster}
package containing all data used to generate the map.
}
\description{
Generate a map image for a specified area or bounding box, by downloading
tiles from \url{https://www.mapbox.com/}. Map is automatically saved in both
\code{.pdf} and \code{.png} formats, by default in current working directory, or
alternative location when \code{mapname} includes the full path.
}
\examples{
\dontrun{
# code used to generate internal files for a portion of Omaha:
bb <- osmdata::getbb ("omaha nebraska")
shrink <- 0.3 # shrink that bb to 30\% size
bb <- t (apply (bb, 1, function (i) {
    mean (i) + c (-shrink, shrink) * diff (i) / 2
}))
ms_generate_map (bb, max_tiles = 16L, mapname = "omaha")
}

}
