% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_data_transformation.R
\name{transform_df_coords}
\alias{transform_df_coords}
\title{Transform Coordinates in Data Frame}
\usage{
transform_df_coords(df, crs)
}
\arguments{
\item{df}{a data.frame containing site names, lat and lon coordinates and admixture data.}

\item{crs}{a coordinate reference system.}
}
\value{
a data.frame with coordinates transformed.
}
\description{
Internal function used to transform latitude and longitude coordinates in
admixture data.frame.
}
\examples{
df <- data.frame(
  site = c("London", "Paris", "Berlin", "Rome", "Madrid"),
  lat = c(51.51, 48.85, 52.52, 41.90, 40.42),
  lon = c(-0.12, 2.35, 13.40, 12.49, -3.70),
  Cluster1 = c(0.95, 0.5, 0.1, 0, 0),
  Cluster2 = c(0.05, 0.45, 0.45, 0.01, 0.75),
  Cluster3 = c(0, 0.05, 0.45, 0.99, 0.25)
)

transform_df_coords(df, crs = 3857)
}
\keyword{internal}
