library("testthat")
library("mapi")
test_that("MAPI_GridHexagonal", {
    library("data.table")
    library("sf")
    data("samples")
    grid <- MAPI_GridHexagonal(samples, crs=3857, hw=250)
    expect_equal(nrow(grid), 1071)
    samplesPlus <- data.table::data.table(ind=samples$ind, x=samples$x*1000, y=samples$y*1000, errRad=samples$errRad*10)
    samples.ll <- sf::st_transform(sf::st_as_sf(samplesPlus, crs=3857, coords=c("x","y")), crs=4326)
    samples4326 <- cbind(sf::st_drop_geometry(samples.ll), sf::st_coordinates(samples.ll))
    data.table::setnames(samples4326, "X", "x")
    data.table::setnames(samples4326, "Y", "y")
    grid.ll <- MAPI_GridHexagonal(samples4326, crs=4326, hw=250000)
    expect_equal(nrow(grid.ll), 2432)
})
