% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_features_to_draw}
\alias{add_features_to_draw}
\title{Add features to an existing draw control}
\usage{
add_features_to_draw(map, source, clear_existing = FALSE)
}
\arguments{
\item{map}{A map object with a draw control already added}

\item{source}{Character string specifying a source ID to get features from}

\item{clear_existing}{Logical, whether to clear existing drawn features before adding new ones. Default is FALSE.}
}
\value{
The modified map object
}
\description{
This function adds features from an existing source to a draw control on a map.
}
\examples{
\dontrun{
library(mapgl)
library(tigris)

# Add features from an existing source
tx <- counties(state = "TX", cb = TRUE)
mapboxgl(bounds = tx) |>
  add_source(id = "tx", data = tx) |>
  add_draw_control() |>
  add_features_to_draw(source = "tx")

# In a Shiny app
observeEvent(input$load_data, {
  mapboxgl_proxy("map") |>
    add_features_to_draw(
      source = "dynamic_data",
      clear_existing = TRUE
    )
})
}
}
