% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_ph.R
\name{ph.mean}
\alias{ph.mean}
\title{Mean of PH distribution}
\usage{
ph.mean(ph, ...)
}
\arguments{
\item{ph}{An instance of PH distribution}

\item{...}{Others}
}
\value{
A value of mean
}
\description{
Compute the mean of a given PH distribution.
}
\examples{
## create a PH with specific parameters
(param1 <- ph(alpha=c(1,0,0), 
              Q=rbind(c(-4,2,0),c(2,-5,1),c(1,0,-1)), 
              xi=c(2,2,0)))

## create a CF1 with specific parameters
(param2 <- cf1(alpha=c(1,0,0), rate=c(1.0,2.0,3.0)))

## create a hyper Erlang with specific parameters
(param3 <- herlang(shape=c(2,3), mixrate=c(0.3,0.7), rate=c(1.0,10.0)))

## mean
ph.mean(param1)
ph.mean(param2)
ph.mean(param3)

}
