% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_herlang.R
\name{herlang}
\alias{herlang}
\title{Create HErlang distribution}
\usage{
herlang(
  size,
  shape,
  mixrate = rep(1/length(shape), length(shape)),
  rate = rep(1, length(shape))
)
}
\arguments{
\item{size}{An integer of the number of phases}

\item{shape}{A vector of shape parameters}

\item{mixrate}{A vector of initial probability (mixrate)}

\item{rate}{A vector of rate parameters}
}
\value{
An instance of HErlang
}
\description{
Create an instance of Hyper-Erlang distribution
}
\note{
If shape is given, shape is used even though size is set.
}
\examples{
## create a hyper Erlang consisting of two Erlang
## with shape parameters 2 and 3.
(param1 <- herlang(shape=c(2,3)))

## create a hyper Erlang with specific parameters
(param2 <- herlang(shape=c(2,3), mixrate=c(0.3,0.7), rate=c(1.0,10.0)))

## convert to a general PH
as.gph(param2)

## p.d.f. for 0, 0.1, ..., 1
(dphase(x=seq(0, 1, 0.1), ph=param2))

## c.d.f. for 0, 0.1, ..., 1
(pphase(q=seq(0, 1, 0.1), ph=param2))

## generate 10 samples
(rphase(n=10, ph=param2))

}
