% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_gmmpp.R
\name{gmmpp}
\alias{gmmpp}
\title{Create GMMPP}
\usage{
gmmpp(size, alpha, D0, D1)
}
\arguments{
\item{size}{An integer for the number of phases}

\item{alpha}{A vector of initial probability}

\item{D0}{An infinitesimal generator without arrivals}

\item{D1}{An infinitesimal generator with arrivals}
}
\value{
An instance of GMMPP
}
\description{
Create an instance of GMMPP
}
\note{
This function can omit several patterns of arguments. For example, \code{map(5)}
omit the arguments \code{alpha}, \code{Q} and \code{xi}. In this case, the default values are
assigned to them.
}
\examples{
## create a map (full matrix) with 5 phases
(param1 <- gmmpp(5))

## create a map with specific parameters
(param2 <- gmmpp(alpha=c(1,0,0),
              D0=rbind(c(-4,2,0),c(2,-5,1),c(1,0,-1)),
              D1=rbind(c(2,0,0),c(0,2,0),c(0,0,0))))

}
