% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/General.R, R/HSManifold.R, R/SphereManifold.R
\name{geodesicCurve}
\alias{geodesicCurve}
\alias{geodesicCurve.HS}
\alias{geodesicCurve.Sphere}
\title{Obtain the geodesic curve}
\usage{
geodesicCurve(mfd, p, h, t)

\method{geodesicCurve}{HS}(mfd, p, h, t)

\method{geodesicCurve}{Sphere}(mfd, p, h, t)
}
\arguments{
\item{mfd}{A class instance that represents the Riemannian manifold}

\item{p}{The starting point of the geodesic curve}

\item{h}{A matrix with each column representing a tangent vector. If there is only one tangent vector is supplied, then it is replicated to match the length of \emph{t}}

\item{t}{A vector, the time points where the curve is evaluated.}
}
\value{
A matrix of points lying on a geodesic. Different columns correspond to different time points

A matrix with each column representing a point on the manifold
}
\description{
Obtain the geodesic curve
}
\details{
The curve is \eqn{\gamma(t)=\mathrm{Exp}_p(th)}
}
\section{Methods (by class)}{
\itemize{
\item \code{geodesicCurve(HS)}: Method

\item \code{geodesicCurve(Sphere)}: Geodesic curve stating at a point

}}
