% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/General.R
\name{frechetMean}
\alias{frechetMean}
\alias{frechetMean.default}
\title{Calculate the Fréchet mean}
\usage{
frechetMean(mfd, X, ...)

\method{frechetMean}{default}(
  mfd,
  X,
  mu0,
  weight = NULL,
  tol = 1e-09,
  maxit = 1000,
  lam = 0.99,
  ...
)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{X}{A matrix with each column being a point on the manifold.}

\item{...}{Passed into specific methods}

\item{mu0}{A matrix of starting points. Each column corresponds to a starting point. If there are multiple columns, then a multistart algorithm is used.}

\item{weight}{A vector of weights for the observations}

\item{tol}{The threshold for determining convergence}

\item{maxit}{Maximum iteration}

\item{lam}{The step length}
}
\value{
A matrix with 1 column containing the Fréchet mean
}
\description{
Calculate the Fréchet mean
}
\section{Methods (by class)}{
\itemize{
\item \code{frechetMean(default)}: Default method

}}
