% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manet.R
\name{manet}
\alias{manet}
\title{Multiple allocation clustering of actor-event networks}
\usage{
manet(y, K = 2, maxT = 5000, seed = 1, link = "min", verbose = FALSE)
}
\arguments{
\item{y}{A n x d actor-event adjacency matrix, whereby y_ij is 1 if actor i attended event j -- 0 otherwise.}

\item{K}{Number of multiple clusters. Default is set to 2.}

\item{maxT}{Number of MCMC iterations. Default is set to 5000.}

\item{seed}{Random seed. Default is 1.}

\item{link}{Method to combine the parameters of the parent clusters into the parameter for the heir cluster. Default is "min". The alternative is "max".}

\item{verbose}{Set to TRUE if you want to see the steps of the MCMC iterations. Defaults is FALSE.}
}
\value{
A manet object consisting of a list with five outputs:
\itemize{
\item{p.allocation.chain}{ A maxT x n x 2^K array with the posterior probabilities of allocation to the heir clusters.}
\item{p.event.chain}{ A maxT x K x d array with the cluster - posterior probabilities of attendance to events.}
\item{p.community.chain}{ A maxT x 2^K matrix with the heir cluster proportions.}
\item{parent.heir.cluster}{ A 2^K x K matrix, which indicates the relationship between parent and heir clusters.}
\item{adj} {The original adjacency matrix.}
\item{proc.time}{ The computational time.}
}
}
\description{
This function infers K multiple allocation cluster for actor-event network data.
}
\examples{
data(deepsouth)
ds<-manet(deepsouth,K=2,maxT=100)
plot(ds)
summary(ds)
}
\keyword{actor-event,}
\keyword{mixture}
\keyword{models,}
\keyword{networks}
