% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/manage_local_repo.R
\name{full_repo_dir}
\alias{full_repo_dir}
\title{Determine the full path for local repo}
\usage{
full_repo_dir(repo_base, version, type = "win", ...)
}
\arguments{
\item{repo_base}{the path of the base of the repository tree. This will have
the following child folders: {repo_base}/bin/ and {repo_base}/src/. A
character vector of length one.}

\item{version}{the version of R that the package should be made available for.
This is not relevant when \code{type} is \code{src}. A character vector
of length one.}

\item{type}{should be \code{"win"} (default), \code{"mac"} or \code{src}
for Windows binary, Mac binary and source package distributions respectively.}

\item{...}{optional arguments to pass to \code{\link{file.path}}}
}
\value{
Full path to the desired local repo's terminal directory.
}
\description{
This will return the full file path of the terminal directory of a given
repo type (and R version number as is appropriate).
}
\examples{
\dontrun{
repo_base <- file.path(".")
version <- '3.0'
full_repo_dir(repo_base, version)
}
}
\references{
\href{http://cran.r-project.org/doc/manuals/R-admin.html}{Setting up a package repository}
}

