% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pipeline.R
\name{Pipeline}
\alias{Pipeline}
\title{Pipeline visualisations}
\description{
A Pipeline object is automatically constructed as calls to
\verb{make_*()} are made. It stores the relationships between targets,
dependencies, and sources.
}
\seealso{
Other pipeline: 
\code{\link{pipeline-accessors}},
\code{\link{pipeline-vis}}
}
\concept{pipeline}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{segments}}{A list of \code{Segment} objects}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Pipeline-add_source_segment}{\code{Pipeline$add_source_segment()}}
\item \href{#method-Pipeline-add_recipe_segment}{\code{Pipeline$add_recipe_segment()}}
\item \href{#method-Pipeline-build}{\code{Pipeline$build()}}
\item \href{#method-Pipeline-clean}{\code{Pipeline$clean()}}
\item \href{#method-Pipeline-touch}{\code{Pipeline$touch()}}
\item \href{#method-Pipeline-annotate}{\code{Pipeline$annotate()}}
\item \href{#method-Pipeline-refresh}{\code{Pipeline$refresh()}}
\item \href{#method-Pipeline-nomnoml}{\code{Pipeline$nomnoml()}}
\item \href{#method-Pipeline-visnetwork}{\code{Pipeline$visnetwork()}}
\item \href{#method-Pipeline-text_summary}{\code{Pipeline$text_summary()}}
\item \href{#method-Pipeline-print}{\code{Pipeline$print()}}
\item \href{#method-Pipeline-save_visnetwork}{\code{Pipeline$save_visnetwork()}}
\item \href{#method-Pipeline-save_nomnoml}{\code{Pipeline$save_nomnoml()}}
\item \href{#method-Pipeline-save_text_summary}{\code{Pipeline$save_text_summary()}}
\item \href{#method-Pipeline-clone}{\code{Pipeline$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-add_source_segment"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-add_source_segment}{}}}
\subsection{Method \code{add_source_segment()}}{
Add an edge to \code{edges}


Add any nodes in \code{private$edges} that are missing from
\code{private$nodes} into \code{private$nodes}


Reconstruct Pipeline edges from Segment edges. Called
primarily to update outofdateness


Add a pipeline segment corresponding to a \code{make_with_source()}
call
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$add_source_segment(
  source,
  targets,
  dependencies,
  packages,
  envir,
  force
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{The path to an R script which makes the \code{targets}}

\item{\code{targets}}{A character vector of paths to files}

\item{\code{dependencies}}{A character vector of paths to files which the
\code{targets} depend on}

\item{\code{packages}}{A character vector of names of packages which \code{targets}
depend on}

\item{\code{envir}}{The environment in which to execute the \code{source} or \code{recipe}.}

\item{\code{force}}{A logical determining whether or not execution of the \code{source}
or \code{recipe} will be forced (i.e. happen whether or not the targets are
out-of-date)}

\item{\code{new_edge}}{An data.frame constructed with \code{new_edge()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{SegmentSource} added to the \code{Pipeline}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-add_recipe_segment"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-add_recipe_segment}{}}}
\subsection{Method \code{add_recipe_segment()}}{
Add a pipeline segment corresponding to a \code{make_with_recipe()}
call
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$add_recipe_segment(
  recipe,
  targets,
  dependencies,
  packages,
  envir,
  force
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{recipe}}{A language object which, when evaluated, makes the \code{targets}}

\item{\code{targets}}{A character vector of paths to files}

\item{\code{dependencies}}{A character vector of paths to files which the
\code{targets} depend on}

\item{\code{packages}}{A character vector of names of packages which \code{targets}
depend on}

\item{\code{envir}}{The environment in which to execute the \code{source} or \code{recipe}.}

\item{\code{force}}{A logical determining whether or not execution of the \code{source}
or \code{recipe} will be forced (i.e. happen whether or not the targets are
out-of-date)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{SegmentRecipe} added to the \code{Pipeline}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-build"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-build}{}}}
\subsection{Method \code{build()}}{
Build all targets
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$build(quiet = getOption("makepipe.quiet"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{quiet}}{A logical determining whether or not messages are signaled}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-clean"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-clean}{}}}
\subsection{Method \code{clean()}}{
Clean all targets
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$clean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-touch"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-touch}{}}}
\subsection{Method \code{touch()}}{
Touch all targets, updating file modification time to
current time. This is useful when you know your targets are all
up-to-date but makepipe doesn't (e.g. after a negligible change was
made to your source code).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$touch()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-annotate"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-annotate}{}}}
\subsection{Method \code{annotate()}}{
Apply annotations to Pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$annotate(labels = NULL, notes = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{labels}}{A named character vector mapping nodes in the \code{Pipeline} onto
labels to display beside them.}

\item{\code{notes}}{A named character vector mapping nodes in the \code{Pipeline} onto
notes to display on beside the labels (nomnoml) or as tooltips (visNetwork).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-refresh"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-refresh}{}}}
\subsection{Method \code{refresh()}}{
Refresh Pipeline to check outofdateness
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$refresh()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-nomnoml"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-nomnoml}{}}}
\subsection{Method \code{nomnoml()}}{
Display the pipeline with nomnoml
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$nomnoml(
  direction = c("down", "right"),
  arrow_size = 1,
  edge_style = c("hard", "rounded"),
  bend_size = 0.3,
  font = "Courier",
  font_size = 12,
  line_width = 3,
  padding = 16,
  spacing = 40,
  leading = 1.25,
  stroke = "#33322E",
  fill_arrows = FALSE,
  gutter = 5,
  edge_margin = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{direction}}{The direction the flowchart should go in}

\item{\code{arrow_size}}{The arrowhead size}

\item{\code{edge_style}}{The arrow edge style}

\item{\code{bend_size}}{The degree of rounding in the arrows (requires
\code{edge_style=rounded})}

\item{\code{font}}{The name of a font to use}

\item{\code{font_size}}{The font size}

\item{\code{line_width}}{The line width for arrows and box outlines}

\item{\code{padding}}{The amount of padding \emph{within} boxes}

\item{\code{spacing}}{The amount of spacing \emph{between} boxes,}

\item{\code{leading}}{The amount of spacing between lines of text}

\item{\code{stroke}}{The color of arrows, text, and box outlines}

\item{\code{fill_arrows}}{Whether arrow heads are full triangles (\code{TRUE}) or
angled (\code{FALSE})}

\item{\code{gutter}}{The amount space to leave around the flowchart}

\item{\code{edge_margin}}{The amount of space to leave between boxes and arrows}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-visnetwork"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-visnetwork}{}}}
\subsection{Method \code{visnetwork()}}{
Display the pipeline with nomnoml
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$visnetwork(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments (other than \code{nodes} and \code{edges}) to pass to
\code{visNetwork::visNetwork()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-text_summary"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-text_summary}{}}}
\subsection{Method \code{text_summary()}}{
Display a text summary of the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$text_summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-print"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-print}{}}}
\subsection{Method \code{print()}}{
Display
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments (other than \code{nodes} and \code{edges}) to pass to
\code{visNetwork::visNetwork()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-save_visnetwork"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-save_visnetwork}{}}}
\subsection{Method \code{save_visnetwork()}}{
Save pipeline visNetwork
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$save_visnetwork(file, selfcontained = TRUE, background = "white", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{File to save HTML into}

\item{\code{selfcontained}}{Whether to save the HTML as a single self-contained
file (with external resources base64 encoded) or a file with external
resources placed in an adjacent directory.}

\item{\code{background}}{Text string giving the html background color of the
widget. Defaults to white.}

\item{\code{...}}{Arguments (other than \code{nodes} and \code{edges}) to pass to
\code{visNetwork::visNetwork()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-save_nomnoml"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-save_nomnoml}{}}}
\subsection{Method \code{save_nomnoml()}}{
Save pipeline nomnoml
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$save_nomnoml(file, width = NULL, height = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{File to save the png into}

\item{\code{width}}{Image width}

\item{\code{height}}{Image height}

\item{\code{...}}{Arguments to pass to \code{self$nomnoml()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-save_text_summary"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-save_text_summary}{}}}
\subsection{Method \code{save_text_summary()}}{
Save a text summary of the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$save_text_summary(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{File to save text summary into}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Pipeline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Pipeline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
