% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePaletteKM.R
\name{makePaletteKM}
\alias{makePaletteKM}
\title{Make your color palette with KMeans algorithm}
\usage{
makePaletteKM(photo, n = 4)
}
\arguments{
\item{photo}{Image location path. It can also be a URL address.}

\item{n}{Number of elements to be generated in the color palette. The default value is 4.}
}
\value{
A palette of colors
}
\description{
Creates a color palette from an image, using the KMeans algorithm
}
\examples{
makePaletteKM(system.file("extdata", "picture02.jpg", package="makePalette"))
makePaletteKM(system.file("extdata", "picture04.png", package="makePalette"), 6)
makePaletteKM(system.file("extdata", "picture05.jpg", package="makePalette"), 10)
MyPalette = makePaletteKM(system.file("extdata", "picture05.jpg", package="makePalette"), 10)
barplot(1:10, col=MyPalette)

}
