% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_km.R
\name{ph_diagplot_schoenfeld}
\alias{ph_diagplot_schoenfeld}
\title{PH Diagnosis Plot of Schoenfeld residuals for a Cox model fit}
\usage{
ph_diagplot_schoenfeld(
  coxobj,
  time_scale = "months",
  log_time = TRUE,
  endpoint_name = "",
  subtitle = ""
)
}
\arguments{
\item{coxobj}{object returned from \code{\link[survival]{coxph}}}

\item{time_scale}{a character string, 'years', 'months', 'weeks' or 'days', time unit of median survival time}

\item{log_time}{logical, TRUE (default) or FALSE}

\item{endpoint_name}{a character string, name of the endpoint}

\item{subtitle}{a character string, subtitle of the plot}
}
\value{
a plot of Schoenfeld residuals
}
\description{
PH Diagnosis Plot of Schoenfeld residuals for a Cox model fit
}
\examples{
library(survival)
data(adtte_sat)
data(pseudo_ipd_sat)
combined_data <- rbind(adtte_sat[, c("TIME", "EVENT", "ARM")], pseudo_ipd_sat)
unweighted_cox <- coxph(Surv(TIME, EVENT == 1) ~ ARM, data = combined_data)
ph_diagplot_schoenfeld(unweighted_cox,
  time_scale = "month", log_time = TRUE,
  endpoint_name = "OS", subtitle = "(Before Matching)"
)
}
