% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-dataset_functions.R
\name{is_dataset}
\alias{is_dataset}
\title{Test if an object is a valid dataset}
\usage{
is_dataset(object)
}
\arguments{
\item{object}{A potential dataset to be evaluated.}
}
\value{
A logical.
}
\description{
Tests if the input object is a valid dataset. This function mainly helps
validate input within other functions of the package but could be used
to check if a dataset is valid.
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.
}
\examples{
{

# use madshapR_examples provided by the package
# any data frame can be a dataset by definition.

is_dataset(madshapR_examples$`dataset_example`)
is_dataset(iris)
is_dataset(AirPassengers)

}

}
\seealso{
For a better assessment, please use \code{\link[=dataset_evaluate]{dataset_evaluate()}}.
}
