% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_filter}
\alias{data_dict_filter}
\title{Subset data dictionary by row values}
\usage{
data_dict_filter(
  data_dict,
  filter_var = NULL,
  filter_cat = NULL,
  filter_all = NULL
)
}
\arguments{
\item{data_dict}{A list of data frame(s) representing metadata to be
filtered.}

\item{filter_var}{Expressions that are defined in the element 'Variables' in
the data dictionary.}

\item{filter_cat}{Expressions that are defined in the element 'Categories' in
the data dictionary.}

\item{filter_all}{Expressions that are defined both in the 'Categories' and
'Variables' in the data dictionary.}
}
\value{
A list of data frame(s) identifying a workable data dictionary structure.
}
\description{
Subsets either or both the 'Variables' and 'Categories' elements of a data
dictionary. Rows are conserved if their values satisfy the condition.
This is a wrapper function analogous to \code{\link[dplyr:filter]{dplyr::filter()}}.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

library(dplyr)

# use madshapR_examples provided by the package
# Data dictionary where the column 'table' is added to 
# refer to the associated dataset.

data_dict <- 
  madshapR_examples$`data_dictionary_example` \%>\% 
  lapply(function(x) mutate(x,table = "dataset"))

###### Example 1 search and filter through a column in 'Variables' element
data_dict_f1 <- data_dict_filter(data_dict,filter_var = "name == 'gndr'")
glimpse(data_dict_f1)

###### Example 2 search and filter through a column in 'Categories' element
data_dict_f2 <- data_dict_filter(data_dict,filter_cat = "missing == TRUE")
glimpse(data_dict_f2)

###### Example 3 search and filter through a column across all elements.
# The column must exist in both 'Variables' and 'Categories' and have the
# same meaning
data_dict_f3 <- data_dict_filter(data_dict,filter_all = "table == 'dataset'")
glimpse(data_dict_f3)

}

}
\seealso{
\code{\link[dplyr:filter]{dplyr::filter()}}
}
