% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{as_data_dict}
\alias{as_data_dict}
\title{Validate and coerce any object as a data dictionary}
\usage{
as_data_dict(object)
}
\arguments{
\item{object}{A potential data dictionary object to be coerced.}
}
\value{
A list of data frame(s) with \code{madshapR::class} 'data_dict'.
}
\description{
Checks if an object is a valid data dictionary and returns it with the
appropriate \code{madshapR::class} attribute. This function mainly helps validate
inputs within other functions of the package but could be used to check if
an object is valid for use in a function. If either the columns 'typeof' or
'class' already exists in 'Variables', or 'na_values', 'labels' in
'Categories', the function will return the same data dictionary. Otherwise,
These columns will be added, using 'valueType' in 'Variables', and, 'label'
and 'missing' in 'Categories.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

library(dplyr)

# use madshapR_examples provided by the package
###### Example 1 : use the function to apply the attribute "data_dict" to the 
# object. 
data_dict <- 
  as_data_dict(madshapR_examples$`data_dictionary_example - as_data_dict`)

glimpse(data_dict)

###### Example 2 : use the function to shape the data dictionary formatted as
# data_dict_mlstr to data_dict object. The function mainly converts valueType 
# column into corresponding typeof/class columns in 'Variables', and converts
# missing column into "na_values" column. 
data_dict <- as_data_dict_mlstr(madshapR_examples$`data_dictionary_example`)
data_dict <- as_data_dict(data_dict)

glimpse(data_dict)

}

}
\seealso{
For a better assessment, please use \code{\link[=data_dict_evaluate]{data_dict_evaluate()}}.
}
