% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{inp_exSglyGrid}
\alias{inp_exSglyGrid}
\title{Mandatory Data for the Example 'Single-Year Grid'}
\format{
A list with three RasterBricks and one RasterLayer.

    Each of the RasterBricks contains a one-year monthly time series for the year 2010,
    for the following climate variables:
    \itemize{
      \item{\code{temp}: mean air temperature (in °C)}
      \item{\code{prec}: precipitation sum (in mm)}
      \item{\code{bsdf}: mean relative sunshine duration (dimensionless)}
    }

    Elevation data can be extracted from a single RasterLayer: \code{elv}.
}
\description{
Data needed to demonstrate the working of functions with a grid mode. Measured monthly time series of
    the year 2010 for three basic climate variables retrieved from the the CarpatClim database
    (Spinoni et al. 2015), for Csongrád-Csanád County; supplemented with a digital elevation model. Monthly mean
    relative sunshine duration has been obtained as a ratio of monthly total of sunshine duration and maximum
    potential number of sunshine hours under clear-sky conditions. Daylength (accumulated hours of daylight) was
    calculated via Eq 1.6.11 in Duffie and Beckman (1991), according to the SPLASH radiation model
    (see \code{\link{cliAvgDlySolIrrPoints}}). For all grids, the WGS84 (EPSG:4326) coordinate system was used
    with a horizontal resolution of 0.1°.
}
\examples{
data(inp_exSglyGrid)
str(inp_exSglyGrid)

}
\references{
\emph{Duffie JA, Beckman WA (1991) Solar Engineering of Thermal Processes. Second Edition. Wiley-Interscience,
    New York, NY}

\emph{Spinoni J, Szalai S, Szentimrey T, Lakatos M, Bihari Z, Nagy A, Németh Á, Kovács T, Mihic D,
    Dacic M, Petrovic P, Kržič A, Hiebl J, Auer I, Milkovic J, Štepánek P, Zahradnícek P, Kilar P, Limanowka D,
    Pyrc R, Cheval S, Birsan M-V, Dumitrescu A, Deak G, Matei M, Antolovic I, Nejedlík P, Štastný P, Kajaba P,
    Bochnícek O, Galo D,  Mikulová K, Nabyvanets Y, Skrynyk O, Krakovska S, Gnatiuk N, Tolasz R, Antofie T, Vogt J
    (2015) Climate  of  the  Carpathian  Region  in  the  period  1961–2010:  climatologies  and  trends  of  10
    variables. Int J Climatol 35(7):1322-1341. \doi{10.1002/joc.4059}}
}
