% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_functions.R
\name{formatOutput}
\alias{formatOutput}
\title{Format the output of maat}
\usage{
formatOutput(examinee_list, digits = 3)
}
\arguments{
\item{examinee_list}{the output from \code{\link{maat}}.}

\item{digits}{digits to round theta values. (default = 3)}
}
\value{
a data frame containing:
\itemize{
  \item{\code{p_ID}}: the person ID.
  \item{\code{test_phase_ID}}: the module position. If we have 3 tests with 2 phases in each test then the range of test_phase_ID is 1 to 6.
  \item{\code{initial_grade}}: the initial grade of the person.
  \item{\code{final_grade}}: the final grade of the person after completing all modules.
  \item{\code{grade_ID}}: the grade at the module position.
  \item{\code{phase_ID}}: the phase at the module position.
  \item{\code{test_ID}}: the test at the module position.
  \item{\code{module_ID}}: the module ID at the module position.
  \item{\code{final_theta_est}}: the grand final estimated \eqn{\theta} after completing all tests.
  \item{\code{final_SE_est}}: the standard error of grand final estimated \eqn{\theta} after completing all tests.
  \item{\code{theta_by_phase}}: the final estimated \eqn{\theta} after completing each phase.
  \item{\code{SE_by_phase}}: the standard error of final estimated \eqn{\theta} after completing each phase.
  \item{\code{combined}}: whether items were combined with the previous phase to obtain the theta estimate.
  \item{\code{true_theta}}: the true \eqn{\theta} in each module position.
  \item{\code{item_ID}}: the item IDs of administered items.
  \item{\code{ncat}}: the number of categories of administered items.
  \item{\code{IRT_model}}: the IRT models of administered items.
  \item{\code{item_par_1}}: the first item parameter of each administered item (e.g., for 1PL, this is item difficulty)
  \item{\code{item_par_2}}: the second item parameter of each administered item (e.g., for 1PL, this is `NA`)
  \item{\code{item_resp}}: the item response on each administered item.
  \item{\code{momentary_theta}}: the momentary (interim) \eqn{\theta} estimate obtained after each item administration in CAT engine.
  \item{\code{momentary_SE}}: the standard error of momentary (interim) \eqn{\theta} estimate obtained after each item administration in CAT engine.
}
}
\description{
\code{\link{formatOutput}} is a function for formatting the output \code{\linkS4class{examinee}} object
of the function \code{\link{maat}} for analysis.
}
