% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{tab}
\alias{tab}
\title{Tabulation}
\usage{
tab(data, ..., by = NULL, row.pct = TRUE, na.rm = FALSE, digits = 1)
}
\arguments{
\item{data}{data.frame}

\item{...}{variable name or names of multiple variables}

\item{by}{variable name for bivariate analysis}

\item{row.pct}{\code{TRUE}, \code{FALSE} or \code{NULL}.}

\item{na.rm}{logical: if \code{TRUE}, it removes observations with missing values.}

\item{digits}{specify rounding of numbers.}
}
\value{
A list with \code{tab} class containing three sets of data.frame type:
\enumerate{
\item tabulation result,
\item tabulation result without any format,
\item labels for corresponding variables.
}
}
\description{
\code{tab()} generates one-way or two-way tabulation of variables.
If no variables are specified, tabulations for all the variables
in the dataset are generated.
}
\details{
\strong{One-way tabulation}

If \code{by} is not specified, \code{tab} generates one-way tabulation of
a variable or multiple variables. The table is displayed
in \code{Freq.} (frequency), \code{Percent}
(Relative Frequency) and \code{Cum.} (Cumulative Relative frequency).

\strong{Two-way tabulation}

Specifying \code{by} leads to two-way tabulation. By default,
row percentages are displayed along with count data. If \code{row.pct}
is set to \code{NULL}, it shows a count table without percentages. If set to
\code{FALSE}, a table with column percentages is generated. P-values from
\code{Chi-squared} and Fisher's \code{Exact} tests are also shown, regardless
of displaying percentages.

\strong{Tabulating the whole dataset}

This is helpful when the dataset has been processed and finalized.
The final dataset can be fed into the function without
inputting any variables. This automatically filters and generates
tables on variables with possible data types for tabulation. These
data types include \code{character}, \code{factor}, \verb{order factor}, and \code{logical}.

\strong{Using colon \code{:} to tabulate multiple variables}

A colon separator \code{:} can be used to generate one-way or two-way
tables efficiently.

\strong{Labels}

Labels for corresponding variables are displayed below the
table.
}
\examples{

## One-way tabulation
tab(infert, education)
tab(infert, education, parity:spontaneous)
tab(infert)

## Two-way tabulation
tab(infert, education, by = case)
tab(infert, education, parity:spontaneous, by = case)
tab(infert, by = case)

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
