% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mExplorer.R
\name{prepare_gmt_input}
\alias{prepare_gmt_input}
\title{Creation of m:Explorer input data frame from GMT files}
\usage{
prepare_gmt_input(gmt_filename, min_genes = NA, max_genes = NA)
}
\arguments{
\item{gmt_filename}{Path to GMT file to convert.}

\item{min_genes}{Numeric indicating to discard pathways with less than min_genes genes. If NA, there is no lower bound on the number of genes. Default is NA.}

\item{max_genes}{Numeric indicating to discard pathways with more than max_genes genes. If NA, there is no upper bound on the number of genes. Default is NA.}
}
\value{
Data frame with pathways as columns, genes as rows. Gene/pathway combinations are marked with "pw" if that gene is in the pathway, or "." if not.
}
\description{
Creation of m:Explorer input data frame from GMT files
}
\examples{
# Create m:Explorer input data frame from GMT "small_gmt.gmt," discarding
# pathways with less than 5 genes and more than 1000 genes
gmt_file = system.file("extdata", "small_gmt.gmt", package = "mExplorer")
gmt = prepare_gmt_input(gmt_file, 5, 1000)
}
