% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top_level.R
\name{ltmm}
\alias{ltmm}
\title{Fit a Left-truncated mixture model (LTMM)}
\usage{
ltmm(
  x,
  G,
  distributions,
  trunc = NULL,
  EM_init_method = "emEM",
  EM_starts = 5,
  init_pars = NULL,
  init_pi = NULL,
  init_classes = NULL,
  one_group_reps = 50,
  eps = 1e-06,
  max.it = 1000,
  verbose = FALSE
)
}
\arguments{
\item{x}{data vector}

\item{G}{number of components}

\item{distributions}{densities to combine}

\item{trunc}{left truncation point (optional)}

\item{EM_init_method}{initialization method for EM algorithm}

\item{EM_starts}{number of random starts for initialization of EM algorithm. (only for G > 1)}

\item{init_pars}{initial parameter values (list of length G)}

\item{init_pi}{manually specified initial component proportions (for init_method=specified)}

\item{init_classes}{manually specified initial classes. will overwrite init_pars and init_pi}

\item{one_group_reps}{number of random starts for each numerical optimization in 1-component model}

\item{eps}{stopping tolerance for EM algoithm}

\item{max.it}{maximum number of iterations of EM algorithm}

\item{verbose}{print information as fitting progresses?}
}
\value{
An ltmm model object, with the following properties:
\describe{
  \item{x}{Copy of the input data}
  \item{distributions}{The selected distributions}
  \item{trunc}{The left truncation value, if specified}
  \item{fitted_pdf}{The probability density function of the fitted model}
  \item{fitted_cfd}{The cumulative density function of the fitted model}
  \item{VaR}{The value-at-risk of the fitted model (function with p taken as onl yargument)}
  \item{ES}{The expected shortfall of the fitted model (function with p taken as onl yargument)}
  \item{G}{The number of components in the model}
  \item{Pi}{The estimated probabilites of component membership}
  \item{Pars}{The estimated model parameters}
  \item{ll}{The log-likelihood of the fitted model}
  \item{bic}{The BIC of the fitted model}
  \item{aic}{The AIC of the fitted model}
  \item{id}{The MAP component membership for each observation}
  \item{iter}{The number of iterations until convergence for the EM algorithm}
  \item{npars}{The total number of model parameters for the fitted model}
  \item{ll.history}{The value of log-likelihood at each iteration of the EM algorithm}
}
}
\description{
This function generates a mixture model combining left-truncated lognormal,
             gamma, and weibull distributions
}
\examples{
\donttest{
x <- secura$Loss

fit <- ltmm(x, G = 2, distributions = c('gamma', 'gamma', 'weibull'), trunc = 1.2e6)

summary(fit)
plot(fit)
}

}
