% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette_extract.R
\name{palette_extract}
\alias{palette_extract}
\title{Extract Hexadecimal Codes from an Image}
\usage{
palette_extract(image, sort = FALSE, progress_bar = TRUE)
}
\arguments{
\item{image}{(character) Name/path to PNG, JPEG, TIFF, or HEIC file from which to extract colors}

\item{sort}{(logical) Whether extracted HEX codes should be sorted by hue and saturation}

\item{progress_bar}{(logical) Whether to `message` a progress bar}
}
\value{
(character) Vector containing all hexadecimal codes remaining after extraction and removal of 'dark' and 'similar' colors
}
\description{
Retrieves hexadecimal codes for the colors in an image file. Currently only PNG, JPEG, TIFF, and HEIC files are supported. The function automatically removes dark colors and removes 'similar' colors to yield 25 colors from which you can select the subset that works best for your visualization needs. Note that photos that are very dark may return few viable colors.
}
\examples{
# Extract colors from a supplied image
my_colors <- palette_extract(image = system.file("extdata", "lyon-fire.png",
package = "lterpalettefinder"), sort = TRUE, progress_bar = FALSE)
       
# Plot that result
palette_demo(palette = my_colors)

}
