% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_contourLines.R
\name{l_layer_contourLines}
\alias{l_layer_contourLines}
\title{Layer Contour Lines}
\usage{
l_layer_contourLines(
  widget,
  x = seq(0, 1, length.out = nrow(z)),
  y = seq(0, 1, length.out = ncol(z)),
  z,
  nlevels = 10,
  levels = pretty(range(z, na.rm = TRUE), nlevels),
  asSingleLayer = TRUE,
  parent = "root",
  index = "end",
  ...
)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{x, y}{As described in \code{grDevices::contourLines}:
locations of grid lines at which the values in z are measured.
These must be in ascending order.
By default, equally spaced values from 0 to 1 are used.
If \code{x} is a list, its components \code{x$x} and \code{x$y} are
used for \code{x} and \code{y}, respectively.
If the list has component \code{z} this is used for \code{z}.}

\item{z}{As described in \code{grDevices::contourLines}: a matrix
containing the values to be plotted (\code{NA}s are allowed).
Note that \code{x} can be used instead of \code{z} for convenience.}

\item{nlevels}{As described in \code{grDevices::contourLines}: number of
contour levels desired iff \code{levels} is not supplied.}

\item{levels}{As described in \code{grDevices::contourLines}: numeric vector
of levels at which to draw contour lines.}

\item{asSingleLayer}{if \code{TRUE} a lines layer is used for the line,
otherwise if \code{FALSE} a group with nested line layers for each line is
created}

\item{parent}{a valid Tk parent widget path. When the parent widget is
specified (i.e. not \code{NULL}) then the plot widget needs to be placed using
some geometry manager like \code{\link{tkpack}} or \code{\link{tkplace}} in
order to be displayed. See the examples below.}

\item{index}{position among its siblings. valid values are 0, 1, 2, ...,
'end'}

\item{...}{arguments forwarded to \code{\link{l_layer_line}}}
}
\value{
layer id of group or lines layer
}
\description{
This function is a wrapper around
  \code{\link[grDevices]{contourLines}} that adds the countourlines to a loon
  plot which is based on the cartesian coordinate system.
}
\details{
For more information run: \code{l_help("learn_R_layer.html#countourlines-heatimage-rasterimage")}
}
\examples{
if(interactive()){

p <- l_plot()
x <- 10*1:nrow(volcano)
y <- 10*1:ncol(volcano)
lcl <- l_layer_contourLines(p, x, y, volcano)
l_scaleto_world(p)

if (requireNamespace("MASS", quietly = TRUE)) {

  p1 <- with(iris, l_plot(Sepal.Length~Sepal.Width, color=Species))
  lcl <- with(iris, l_layer_contourLines(p1, MASS::kde2d(Sepal.Width,Sepal.Length)))

  p2 <- with(iris, l_plot(Sepal.Length~Sepal.Width, color=Species))
  layers <- sapply(split(cbind(iris, color=p2['color']), iris$Species), function(dat) {
       kest <- with(dat, MASS::kde2d(Sepal.Width,Sepal.Length))
       l_layer_contourLines(p2, kest, color=as.character(dat$color[1]), linewidth=2,
            label=paste0(as.character(dat$Species[1]), " contours"))
  })
}

}
}
