% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_hull.R
\name{l_layer_hull}
\alias{l_layer_hull}
\title{Layer a hull for \code{loon}}
\usage{
l_layer_hull(
  widget,
  x,
  y,
  color = "black",
  linewidth = 1,
  label = "hull",
  parent = "root",
  index = 0,
  group = NULL,
  active = TRUE,
  ...
)
}
\arguments{
\item{widget}{`loon` widget path name as a string}

\item{x}{The coordinates of \code{x}. See details}

\item{y}{The coordinates of \code{y}. See details}

\item{color}{the line color of each hull}

\item{linewidth}{the line width}

\item{label}{label used in the layers inspector}

\item{parent}{parent group layer}

\item{index}{of the newly added layer in its parent group}

\item{group}{separate x vector or y vector into a list by group}

\item{active}{a logical determining whether points appear or not (default is \code{TRUE} for all points).
If a logical vector is given of length equal to the number of points,
then it identifies which points appear (\code{TRUE}) and which do not (\code{FALSE}).}

\item{...}{other arguments to modify \code{l_layer_line}.}
}
\value{
an \code{l_layer} widget
}
\description{
Creates a layer which is the subset of points lying on the hull (convex or alpha) of the set of points specified.
}
\details{
Coordinates: the \code{x} or \code{y} can be a list or a vector.
\itemize{
  \item {If they are vectors, the argument \code{group} will be used to set the groups.}
  \item {If they are not provided, the \code{x} will be inherited from the widget}
}
}
\examples{
if(interactive()) {
p <- l_plot(iris, color = iris$Species)
l <- l_layer_hull(p, group = iris$Species)
}

}
