% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longitudinal_consensus_cluster.R
\name{plot.lcc}
\alias{plot.lcc}
\title{Plot a longitudinal consensus clustering}
\usage{
\method{plot}{lcc}(x, color_palette = NULL, ...)
}
\arguments{
\item{x}{\code{lcc} object (output from \code{\link{longitudinal_consensus_cluster}})}

\item{color_palette}{optional character vector of colors for consensus matrix}

\item{...}{additional parameters for plotting; currently not used}
}
\value{
Plots the following plots:\tabular{ll}{
\code{consensus matrix legend} \tab the legend for the following consensus matrix plots \cr
\tab \cr
\code{consensus matrix plot} \tab for every specified number of clusters, a heatmap of the consensus matrix and the result of the final clustering is shown \cr
\tab \cr
\code{consensus CDF} \tab a line plot of the CDFs for all different specified numbers of clusters \cr
\tab \cr
\code{Delta area} \tab elbow plot of the difference in the CDFs between the different numbers of clusters \cr
\tab \cr
\code{tracking plot} \tab cluster assignment of the subjects throughout the different cluster solutions \cr
\tab \cr
\code{item-consensus} \tab for every item (subject), calculate the average consensus value with all items that are assigned to one consensus cluster. This is repeated for every cluster and for all different numbers of clusters \cr
\tab \cr
\code{cluster-consensus} \tab every bar represents the average pair-wise item-consensus within one consensus cluster
}
}
\description{
Plot a longitudinal consensus clustering
}
