% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KE_fit.R
\name{KE_fit}
\alias{KE_fit}
\title{KE_fit}
\usage{
KE_fit(train,test,T1,T2,bw_time,bw_subj,alpha=0.05,seed=1,coefCI=FALSE)
}
\arguments{
\item{train}{A long format data matrix containing columns ordered by
time, subject ID, response, predictor1, predictor2, ...
where the measurement time of the longitudinal data should be discretized within T1.}

\item{test}{A long format data matrix containing columns ordered by
time, subject ID, response, predictor1, predictor2, ...
where the measurement time of the longitudinal data should be discretized within T2.}

\item{T1}{A measurement time domain where the functional predictors are measured within}

\item{T2}{A measurement time domain where the functional response is of interest to predict}

\item{bw_time}{(optimal) time bandwidth}

\item{bw_subj}{(optimal) trajectory/subject bandwidth}

\item{alpha}{confidence level for bootstrap CI of alpha_0, alpha_1, ...}

\item{seed}{A random seed fo producing replicable bootstrap CI of alpha_0, alpha_1, ...}

\item{coefCI}{Logical statement: TRUE to derive bootstrap CI of alpha0, alpha1, ... default is FALSE}
}
\value{
A list containing 6 elements
\item{testTraj}{A num.test x num.T2 matrix containing num.test subjects' trajectories where num.T2
                is the total number of the discrete measurement time over T2}
\item{proxycoeff}{Coefficient estimation for the non-negative least square regression. From left to
                  right they are alpha_0, alpha_1, ...}
\item{fpca.fit}{A list containing FPCA fit for the functional predictors and the functional response}
\item{w.hat}{A list containing num.test elements where ith element contains the proxy distance/similarity
               between ith testing subject and other training subjects}
\item{bootCI.mean}{Bootstrap confidence interval of alpha_0, alpha_1, ...}
\item{input.list}{A list containing the input arguments}
}
\description{
Function used to predict response trajectory by nonparametric kernel estimator
}
\examples{
\donttest{t_all = 1:50}
\donttest{T1=c(1,25);T2=c(26,50)}
\donttest{data = datagen(ntotal=350,ntest=50,t_all=t_all,t_split=25,seed=1)}
\donttest{train = data$train}
\donttest{test = data$test}
\donttest{ke.fit = KE_fit(train=train,test=test,T1=T1,T2=T2,bw_time=1,bw_subj = 0.2)}

}
\references{
\cite{Wang S, Kim S, Cho H, Chang W.
      Nonparametric predictive model for sparse and irregular longitudinal data. (2023+)}
}
