% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvncovar2.R
\name{mvncovar2}
\alias{mvncovar2}
\title{Bayesian multivariate normal regression with unstructured covariance  matrix for high dimensional longitudinal data.}
\usage{
mvncovar2(m, n, time, group, chains, iter, data)
}
\arguments{
\item{m}{Starting number of column from where repeated observations begin}

\item{n}{Ending number of columns till where the repeated observations ends}

\item{time}{Timepoint information on which repeadted observations were taken}

\item{group}{A categorical variable either 0 or 1. i.e. Gender - 1 male and 0 female}

\item{chains}{Number of MCMC chains to be performed}

\item{iter}{Number of iterations to be performed}

\item{data}{High dimensional longitudinal data}
}
\value{
mvncovarout
}
\description{
Multivariate normal regression with group covaraites and unstructured covariance matrix.
}
\examples{
##
data(repdata)
mvncovar2(m=4,n=7,time="Age",group="Gender",chains=4,iter=100,data=repdata)
##
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R and OpenBUGS. CRC Press.

Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B., Vehtari, A., & Rubin, D. B. (2013). Bayesian data analysis. CRC press.

Fitzmaurice, G. M., Laird, N. M., & Ware, J. H. (2012). Applied longitudinal analysis (Vol. 998). John Wiley & Sons.
}
\author{
Atanu Bhattacharjee, Akash Pawar and Bhrigu Kumar Rajbongshi
}
