% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BysmxHPD.R
\name{BysmxHPD}
\alias{BysmxHPD}
\title{Bayesian mixed effect model for high dimensional longitduinal data with highest posterior density interval (HPDI).}
\usage{
BysmxHPD(m, tmax, t, group, chains, iter, out, data)
}
\arguments{
\item{m}{Starting number of column from where repeated observations begin}

\item{tmax}{Ending number of columns till where the repeated observations ends}

\item{t}{Timepoint information on which repeadted observations were taken}

\item{group}{A categorical variable either 0 or 1. i.e. Gender - 1 male and 0 female}

\item{chains}{Number of MCMC chains to be performed}

\item{iter}{Number of iterations to be performed}

\item{out}{DIC/HPD outcome}

\item{data}{High dimensional longitudinal data}
}
\value{
Gives posterior means, standard deviation.
}
\description{
Bayesian mixed effect model with random intercept and slopes provides inference with highest posterior density interval (HPDI).
Data longitudinally measured missing value and having batched
information.
Fits using MCMC on longitudinal data set
}
\examples{
##
data(msrep)
BysmxHPD(m=c(4,8,12),tmax=4,t="Age",group="Gender",chains=4,iter=1000,out="hpD",data=msrep)
##
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R and OpenBUGS. CRC Press.

Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B., Vehtari, A., & Rubin, D. B. (2013). Bayesian data analysis. CRC press.

Fitzmaurice, G. M., Laird, N. M., & Ware, J. H. (2012). Applied longitudinal analysis (Vol. 998). John Wiley & Sons.
}
\author{
Atanu Bhattacharjee, Akash Pawar and Bhrigu Kumar Rajbongshi
}
