% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_var_array.R
\name{get_var_sequence}
\alias{get_var_sequence}
\title{Get variable values from subject/variable name pair}
\usage{
get_var_sequence(data, subj_var, subj, var)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a \code{tibble}).}

\item{subj_var}{A character string referring to the variable
that specifies the "subject" variable.}

\item{subj}{Any value that the "subject" variable can take.}

\item{var}{A character string referring to the variable that
contains the variable values.}
}
\value{
A vector of values from variable \code{var}
which \code{subj_var} equal to \code{subj}.
}
\description{
Get variable values from subject/variable name pair
}
\examples{
get_var_sequence(sleep, subj_var = "ID", 1, "extra")
}
