% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peek.R
\name{peek}
\alias{peek}
\title{Take a Quick Overview of Your Data}
\usage{
peek(x, width = getOption("width"), ...)
}
\arguments{
\item{x}{The object to be inspected.}

\item{width}{\code{integer(1)}. Specifies the maximum width of the output.}

\item{...}{Additional arguments to pass to \code{\link[utils:str]{utils::str()}}.}
}
\value{
The input object \code{x}, returned invisibly.
}
\description{
\code{peek()} provides a transposed view of your dataset: columns are displayed vertically, while the data for each column
is shown horizontally. This layout allows you to inspect all the columns of a \code{data.frame} at a glance. It serves as a
convenient wrapper around \code{\link[utils:str]{utils::str()}}, with the added benefit of invisibly returning the input object, making it
suitable for use in data pipelines.
}
\examples{
peek(mtcars)
}
