% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logisticPCA.R
\name{fitted.lpca}
\alias{fitted.lpca}
\title{Fitted values using logistic PCA}
\usage{
\method{fitted}{lpca}(object, type = c("link", "response"), ...)
}
\arguments{
\item{object}{logistic PCA object}

\item{type}{the type of fitting required. \code{type = "link"} gives output on the logit scale and
\code{type = "response"} gives output on the probability scale}

\item{...}{Additional arguments}
}
\description{
Fit a lower dimentional representation of the binary matrix using logistic PCA
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

# run logistic PCA on it
lpca = logisticPCA(mat, k = 1, m = 4, main_effects = FALSE)

# construct fitted probability matrix
fit = fitted(lpca, type = "response")
}

