% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add1.R
\encoding{UTF-8}
\name{add1.logistf}
\alias{add1.logistf}
\title{Add or Drop All Possible Single Terms to/from a \code{logistf} Model}
\usage{
\method{add1}{logistf}(object, scope, data, test = "PLR", ...)
}
\arguments{
\item{object}{A fitted \code{logistf, flic} or \code{flac} object}

\item{scope}{The scope of variables considered for adding or dropping. Should be a
vector of variable names. Can be left missing; the method will then use all variables
in the object's data slot which are not identified as the response variable.}

\item{data}{The data frame used to fit the object.}

\item{test}{The type of test statistic. Currently, only the PLR test (penalized likelihood
ratio test) is allowed for logistf fits.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A matrix with \code{nvar} rows and 3 columns (Chisquared, degrees of freedom, p-value).
}
\description{
Compute all the single terms in the scope argument that can be added to or dropped
from the model, fit those models and compute a table of the changes in fit.
}
\details{
\code{drop1} and \code{add1} generate a table where for each variable the penalized
likelihood ratio chi-squared, the degrees of freedom, and the p-value for dropping/adding this variable are given.
}
\examples{
data(sex2) 
fit<-logistf(data=sex2, case~1, pl=FALSE) 
add1(fit, scope=c("dia", "age"), data=sex2)
 
fit2<-logistf(data=sex2, case~age+oc+dia+vic+vicl+vis) 
drop1(fit2, data=sex2)

}
