% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{sanitizers}
\alias{sanitizers}
\alias{default_ndjson_sanitizer}
\alias{default_ndjson_unsanitizer}
\title{Sanitization for ndJSON.}
\usage{
default_ndjson_sanitizer(string)

default_ndjson_unsanitizer(string)
}
\arguments{
\item{string}{A character vector.}
}
\value{
A character vector.
}
\description{
\emph{Sanitizer} and \emph{unsanitizer} are needed because the \code{ndjson} format requires that each line be a valid JSON object,
thus special characters must be escaped. The functions worke in such a way that the concatenation
\code{unsanitizer(sanitizer())} corresponds to the identity function.
}
\details{
The default sanatizer and unsanatizer are based on the following mapping:\tabular{ll}{
   Character \tab Replacement \cr
   \verb{\\} \tab \verb{\\\\} \cr
   \verb{"} \tab \verb{\\"} \cr
   \verb{\\r} \tab \verb{\\\\r} \cr
   \verb{\\n} \tab \verb{\\\\n} \cr
}
}
\examples{
\dontrun{
  default_ndjson_sanitizer('This is \n an "example"')
  default_ndjson_unsanitizer('This is \\\\n an \\\\"example\\\\"')
}

}
\keyword{internal}
