% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIA_functions.R
\name{estimate_GIA}
\alias{estimate_GIA}
\title{Take in dose A and dose B combinations and estimate GIA}
\usage{
estimate_GIA(model_params, dose_A, dose_B, fn = base_GIA, fn_list = NULL)
}
\arguments{
\item{model_params}{named vector of parameters to be used in function}

\item{dose_A}{numeric vector of doses (e.g. mg/mL) of dose_A}

\item{dose_B}{numeric vector of doses (e.g. mg/mL) of dose_B}

\item{fn}{the function used to calculate GIA.  The default is base_GIA.  See ?base_GIA for more details.}

\item{fn_list}{additional parameters to pass to the function to estimate GIA}
}
\value{
vector of the same size of dose_A and dose_B where each entry is the estimated GIA for the combination of dose A and dose B
}
\description{
Take in dose A and dose B combinations and estimate GIA
}
\examples{
model_params <- c("beta_A" = 1, "beta_B" = 2, "gamma_A" = .5,
"gamma_B" = .6,  "tau_1" = 1, "tau_2" = 0)
dose_A <- c(0, 1, 0)
dose_B <- c(0, 0, 1)
estimate_GIA(model_params, dose_A, dose_B)
}
