% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{identity_kernel}
\alias{identity_kernel}
\title{LIME kernel that treats all observations as equally similar to the observation of interest.}
\usage{
identity_kernel(explained_instance, simulated_instance)
}
\arguments{
\item{explained_instance}{explained instance}

\item{simulated_instance}{new observation}
}
\value{
numeric
}
\description{
Kernels are meant to be used as an argument to individual_surrogate_model function.
Other custom functions can be used. Such functions take two vectors and
return a single number.
}
\examples{
library(DALEX)
library(randomForest)
library(localModel)
data('apartments')
mrf <- randomForest(m2.price ~., data = apartments, ntree = 50)
explainer <- explain(model = mrf,
                     data = apartments[, -1])
model_lok <- individual_surrogate_model(explainer, apartments[5, -1],
                                        size = 500, seed = 17,
                                        kernel = identity_kernel)
# In this case each simulated observation has equal weight
# when explanation model (LASSO) is fitted.
model_lok
plot(model_lok)

}
