% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{list_cached_models}
\alias{list_cached_models}
\title{List cached models on disk}
\usage{
list_cached_models(cache_dir = NULL)
}
\arguments{
\item{cache_dir}{Optional cache directory to inspect. Defaults to the package
cache used by `model_load()`.}
}
\value{
A data frame with one row per cached model and the columns
  `name` (file name), `path` (absolute path), `size_bytes`, and `modified`.
  Returns an empty data frame when no models are cached.
}
\description{
Enumerates the models that have been downloaded to the local cache. This is
useful when you want to reuse a previously downloaded model but no longer
remember the original URL. The cache directory can be overridden with the
`LOCALLLM_CACHE_DIR` environment variable or via the `cache_dir` argument.
}
