% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalizationClassifier.R
\name{localizationClassifier}
\alias{localizationClassifier}
\title{Localization classifier}
\usage{
localizationClassifier(trainingSample, testSample, classNames, k_opt, g_pi)
}
\arguments{
\item{trainingSample}{matrix p by n, being n the number of functions and p the number of grid points.
The colnames of the trainingSample matrix are i_groupName where i goes from 1 to the sample size of the group.}

\item{testSample}{matrix p by n, being n the number of functions to classify and p the number of grid points.}

\item{classNames}{character vector with the group names.}

\item{k_opt}{Maximum order of the localization processes used in the classification rule.}

\item{g_pi}{Vector of size g with a priori probabilities for the bayes classifier. If it is missing the probability is defined by
the proportion of curves of each group.}
}
\value{
Two named training and test. Training contains the estimations made with the training sample
(localization statistics and localization distances). Test contains the classification results
(for each incoming data, localization distances in each group, prior probabilities used,
likelihood in each group and the predicted_class).
}
\description{
Given a training sample with g groups, it predicts the group of the test sample.
}
\examples{
X <- classificationData
ids_training <- sample(colnames(X), 90)
ids_testing <- setdiff(colnames(X), ids_training)
trainingSample <- X[,ids_training]
testSample <- X[,ids_testing]; colnames(testSample) <- NULL #blind
classNames <- c("G1", "G2")
classification_results <- localizationClassifier(trainingSample, testSample, classNames, k_opt = 3)

}
\references{
Elías, Antonio, Jiménez, Raúl and Yukich, Joe (2020). Localization processes for functional data analysis (submitted).
}
