% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locStra.r
\name{jaccardMatrix}
\alias{jaccardMatrix}
\title{C++ implementation to compute the Jaccard similarity matrix for a (sparse) input matrix.}
\usage{
jaccardMatrix(m, useCpp = TRUE, sparse = TRUE)
}
\arguments{
\item{m}{A (sparse) matrix for which the Jaccard similarity matrix is sought. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{useCpp}{Flag to switch between R or C++ implementations. Default is \code{useCpp=TRUE}.}

\item{sparse}{Flag to switch between purpose-built dense or sparse implementations. Default is \code{sparse=TRUE}.}
}
\value{
The Jaccard matrix of \code{m}.
}
\description{
C++ implementation to compute the Jaccard similarity matrix for a (sparse) input matrix.
}
\examples{
require(locStra)
require(Matrix)
m <- matrix(sample(0:1,15,replace=TRUE),ncol=3)
sparseM <- Matrix(m,sparse=TRUE)
print(jaccardMatrix(sparseM))

}
\references{
Dmitry Prokopenko, Julian Hecker, Edwin Silverman, Marcello Pagano, Markus Noethen, Christian Dina, Christoph Lange and Heide Fier (2016). Utilizing the Jaccard index to reveal population stratification in sequencing data: a simulation study and an application to the 1000 Genomes Project. Bioinformatics, 32(9):1366-1372.
}
