% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locStra.r
\name{bed_fastJaccardEVs}
\alias{bed_fastJaccardEVs}
\title{Computation of the k leading eigenvectors of the Jaccard similarity matrix directly from a bed+bim+fam file.. Note that this computation is only approximate and does not necessarily coincide with the result obtained by extracting the k leading eigenvectors of the Jaccard matrix computed with the function \code{jaccardMatrix}.}
\usage{
bed_fastJaccardEVs(f, k, q = 2)
}
\arguments{
\item{f}{The filename of the bed file (including its extension). The bim and fam files need to be in the same folder and have the same base filename.}

\item{k}{The number of leading eigenvectors.}

\item{q}{The number of power iteration steps (default is \code{q=2}).}
}
\value{
The k leading eigenvectors of the Jaccard matrix of \code{m} as a column matrix.
}
\description{
Computation of the k leading eigenvectors of the Jaccard similarity matrix directly from a bed+bim+fam file.. Note that this computation is only approximate and does not necessarily coincide with the result obtained by extracting the k leading eigenvectors of the Jaccard matrix computed with the function \code{jaccardMatrix}.
}
\examples{
require(locStra)

}
\references{
Dmitry Prokopenko, Julian Hecker, Edwin Silverman, Marcello Pagano, Markus Noethen, Christian Dina, Christoph Lange and Heide Fier (2016). Utilizing the Jaccard index to reveal population stratification in sequencing data: a simulation study and an application to the 1000 Genomes Project. Bioinformatics, 32(9):1366-1372.

N. Halko, P.G. Martinsson, and J.A. Tropp (2011). Finding Structure with Randomness: Probabilistic Algorithms for Constructing Approximate Matrix Decompositions. SIAM Review: 53(2), pp. 217--288.

F. Prive, M. Blum, H. Aschard, B.J. Vilhjalmsson (2022). bigsnpr: Analysis of Massive SNP Arrays. https://cran.r-project.org/package=bigsnpr
}
