% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lscore.R
\name{lscore}
\alias{lscore}
\title{Load Shape Score}
\usage{
lscore(ls, type = "acf", output = 2, lag = NULL)
}
\arguments{
\item{ls}{An object of class \code{lslin} or
\code{lslog}, created using function \code{\link{lslin}}
or \code{\link{lslog}}}

\item{type}{Type of correlation to be
evaluate, either \code{"acf"} or \code{"pacf"}}

\item{output}{Type of output to be used, either 1 or 2;
uses \code{ls$y} if 1 and \code{ls$y2} if 2}

\item{lag}{Maximum lag at which to calculate the acf or pacf.
Same as \code{lag.max} in \code{\link{acf}}.
If \code{Null}, then default is used.}
}
\value{
A list of the followings:
\itemize{

\item{\code{wmape}: Weighted MAPE.}


\item{\code{lag}: Lags at which ACF or PACF
values were evaluated and used in calculating \code{wmape}.}


\item{\code{type}: Type of Correlation (ACF or PACF)}


\item{\code{cor_x}: ACF/PACF values of the original load.}


\item{\code{cor_y}: ACF/PACF values of the derived load.}


\item{\code{weight}: Weights at different lags used to
calculate \code{wmape}}.



}
}
\description{
\code{lscore} provides a diagnostic score
for evaluating the derived load shape in
retaining time series properties.
}
\details{
The diagnostic measure is calculated
as a weighted mean absolute percent error (MAPE)
of auto correlation or partial auto correlation
values of the derived series with respect to the original.
The values are calculated for given lag. Lag = 0 is omitted
from calculation for auto correlation as it would be always 1.
If \eqn{o_i} and \eqn{d_i} are the correlation values of
original and derived load shape at lag \eqn{i}, then weighted
MAPE is calculated as




\deqn{wmape = \sum _{i=1}^{lag} { w_i * |(o_i - d_i) / o_i|}}
where \eqn{w_i = \frac{|o_i|}{\sum _{i=1}^{lag}|o_i|}}


Since  \code{wmape} is a measure of error, lower value
indicates better preservation of time
series property.
}
\examples{
loads <- ercot[ercot$Year == 2019, ]$COAST
linear_loadshape <- lslin(loads, target_lf = 0.4)
# --------------
scores_1 <- lscore(linear_loadshape, type = "acf", lag = 20)
print(scores_1)
# --------------
scores_2 <- lscore(linear_loadshape, type = "pacf")
print(scores_2)







}
