% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmls.R
\name{lmls}
\alias{lmls}
\title{Gaussian location-scale regression}
\usage{
lmls(
  location,
  scale = ~1,
  data = environment(location),
  light = TRUE,
  maxit = 100,
  reltol = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{location}{A two-sided formula with the response variable on the LHS
and the predictor for the mean on the RHS.}

\item{scale}{A one-sided formula with the predictor for the standard
deviation on the RHS.}

\item{data}{A data frame (or list or environment) in which to evaluate
the \code{location} and \code{scale} formulas.}

\item{light}{If \code{TRUE}, the design matrices are removed from the estimated
model to save some memory.}

\item{maxit}{The maximum number of iterations of the Fisher scoring
algorithm.}

\item{reltol}{The relative convergence tolerance of the Fisher scoring
algorithm.}
}
\value{
A fitted linear model for location and scale as an \code{lmls} S3 object.
The object has at least the following entries:
\itemize{
\item \code{y}: the response vector
\item \code{nobs}: the number of observations
\item \code{df}: the degrees of freedom
\item \code{df.residual}: the residual degrees of freedom
\item \code{coefficients}: the regression coefficients as a list with the names
\code{location} and \code{scale}
\item \code{fitted.values}: the fitted values as a list with the names \code{location}
and \code{scale}
\item \code{residuals}: the response residuals
\item \code{coefficients}: the variance-covariance matrices of the regression
coefficients as a list with the names \code{location} and \code{scale}
\item \code{iterations}: the number of iterations the Fisher scoring algorithm
took to converge
}
}
\description{
The location-scale regression model assumes a normally distributed response
variable with one linear predictor for the mean (= the location) and one for
the standard deviation (= the scale). The standard deviation is mapped to
the linear predictor through a log link.

This function sets up the model object and estimates it with maximum
likelihood.
}
\examples{
library(lmls)
m <- lmls(y ~ poly(x, 2), ~ x, data = abdom)
summary(m)
plot(m)
qqnorm(m)
}
