% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_lipidome.R
\name{heatmap_lipidome}
\alias{heatmap_lipidome}
\title{Create 'lipidomeR' heatmaps of arbitrary lipid-specific values.}
\usage{
heatmap_lipidome(
  x,
  names.mapping,
  axis.x.carbons = TRUE,
  class.facet = "row",
  fill.direction = "increasing",
  fill.limits = c(0, 40),
  fill.midpoint = 20,
  melt.value.name = "CV",
  melt.variable.name = NULL,
  melt.x = TRUE,
  range.min.N.carbons = 5,
  range.min.N.double.bonds = 5,
  scale.fill.log = NULL,
  scales = "free_y",
  space = "free",
  x.names = "row.names",
  x.variables = NULL
)
}
\arguments{
\item{x}{(Required) named vector of numeric values to create a figure of.
Names need to match to the argument names.mapping through
the function \code{\link{map_lipid_names}}. Alternatively, a data frame
can be supplied. In that case, set \code{melt.x = TRUE}.}

\item{names.mapping}{(Required) mapping of lipid names from
the \code{\link{map_lipid_names}} function.}

\item{axis.x.carbons}{(Optional) \code{TRUE} or \code{FALSE}: Should
the lipid size (i.e., number of carbon atoms in the fatty acid chain) be
presented on the x-axis or y-axis?}

\item{class.facet}{(Optional) character string with possible values
\code{'col'}, \code{'row'} or \code{'wrap'}:
Present lipid classes as panels organized into columns, rows or into a
wrapped layout spanning over multiple rows and columns. The alternative
\code{'wrap'} is only available with \code{plot.infividual = TRUE}.}

\item{fill.direction}{(Optional) \code{TRUE} or \code{FALSE}: Should color
fill be in an increasing direction?}

\item{fill.limits}{(Optional) numeric vector of length two, indicating
the limits of the fill scale.}

\item{fill.midpoint}{(Optional) numeric value specifying the midpoint of
the fill scale.}

\item{melt.value.name}{(Optional) character string, specifying the name of
the variable that will be shown as fill in the heatmap.}

\item{melt.variable.name}{(Optional) character string, specifying the name of
of the variable that will be used to creating faceted sub-heatmaps.}

\item{melt.x}{(Optional) \code{TRUE} or \code{FALSE}: Should the argument
\code{x} be molten by the function \code{\link[reshape2]{melt}}
prior to plotting? Set \code{melt.x = TRUE}, if you want to plot a data
frame instead of a vector of values. In that case, each column of the
data frame will be plotted as an individual facet.}

\item{range.min.N.carbons}{(Optional) numeric value to specify the minimum
range of the axis showing the lipid size (number of carbon atoms in the
fatty acid chains). This value can be increased from the default value to
improve readability in situtions, where there are lipid classes with
little or no variation in the lipid size.}

\item{range.min.N.double.bonds}{(Optional) numeric value to specify
the minimum range of the axis showing the lipid saturation (number of
double bonds in the fatty acid chains). This value can be increased from
the default value to improve readability in situtions, where there are
lipid classes with little or no variation in the lipid saturation.}

\item{scale.fill.log}{(Optional) numeric value specifying the base of
the logarithm, which will be used to creating a logarithmic scale for
the fill scale of the plot.}

\item{scales}{(Optional) character string with possible values
\code{'fixed'}, \code{'free'}, \code{'free_x'} or \code{'free_y'}. This
argument specifies, whether the axes in multiple sub-heatmaps will be in
the same scale (\code{'fixed'}) or in a scale specific to each sub-figure.
See the function \code{\link[ggplot2]{facet_grid}} for details.}

\item{space}{(Optional) character string with possible values
\code{'fixed'}, \code{'free'}, \code{'free_x'} or \code{'free_y'}.
This argument specifies, whether the sub-heatmaps will be of identical
size (\code{'fixed'}) or not.}

\item{x.names}{(Optional) character string specifying the name of the
variable in the argument \code{x}, which will be used to matching
the values to the argument \code{names.mapping}.
Use this argument only together with \code{melt.x = TRUE}.}

\item{x.variables}{(Optional) character vector specifying the names of
the variables, which will be included as individual facets in
the figure.
Use this argument only together with \code{melt.x = TRUE}.}
}
\description{
Use this function to create a heatmap of any lipid-specific values.
   Note: Use the function \code{\link{heatmap_lipidome_from_limma}} to create
   heatmaps of model statistics.
}
