% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_models_with_limma.R
\name{compute_models_with_limma}
\alias{compute_models_with_limma}
\title{Compute lipid-specific regression models}
\usage{
compute_models_with_limma(
  x,
  dependent.variables,
  independent.variables,
  random.effect = NULL,
  formula = NULL,
  F.test = FALSE,
  print.table1 = FALSE,
  scale.dependent.variables = TRUE,
  scale.independent.variables = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{(Required) data matrix.}

\item{dependent.variables}{(Required) vector of names of dependent variables.
These should be the names of the lipids.}

\item{independent.variables}{(Required) vector of names of the independent variables.
These should be the names of the variables defining the experiment design.}

\item{random.effect}{(Optional) name of a single variable specifying
the random effect for a random-effects model.
For instance, \code{ID} specifies a random effect as in
\code{limma::duplicateCorrelation( ..., block = x$'ID' )}.}

\item{formula}{(Optional) character string of model formula in the format accepted by
the function \code{\link[stats]{model.matrix}} and starting with \code{~}.
Variables mentioned in the formula should be included in
the \code{independent.variables} argument.
For instance, \code{Group * Treatment}.}

\item{F.test}{(Optional) \code{TRUE} or \code{FALSE}:
Should an F-test for analysis of variance (ANOVA) or
analysis of covariance (ANCOVA) be computed?}

\item{print.table1}{(Optional) \code{TRUE} or \code{FALSE}:
Should a summary table of the independent variables be printed?}

\item{scale.dependent.variables}{(Optional) \code{TRUE} or \code{FALSE}:
Should dependent variables be scaled to zero-mean and unit-variance
prior to model fitting?}

\item{scale.independent.variables}{(Optional) \code{TRUE} or \code{FALSE}:
Should independent variables be scaled to zero-mean and unit-variance
prior to model fitting?}

\item{verbose}{(Optional) \code{TRUE} or \code{FALSE}: Print messages from
the model fitting?}
}
\value{
List of regression results the that can be directly supplied as
   an argument to the function \code{\link{heatmap_lipidome_from_limma}} and
   other visualization functions of the lipidomeR.
}
\description{
Use this function to computing multiple regression models that can be
   directly supplied to the visualization functions of the 'lipidomeR'.
}
\seealso{
\code{\link{heatmap_lipidome_from_limma}} for visualizing the
   output of this function.
}
