% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto.R
\name{auto}
\alias{auto}
\alias{to_pkg}
\alias{to_call}
\title{Setup automatic linking}
\usage{
auto(type = c("tooltip", "plain"), keep_braces = TRUE, keep_pkg_prefix = TRUE)

to_pkg(pkg, type = c("tooltip", "plain"), keep_braces = TRUE, ...)

to_call(call, type = c("tooltip", "plain"), keep_pkg_prefix = TRUE, ...)
}
\arguments{
\item{type}{"plain" for plain links, "tooltip" for adding a tooltip}

\item{keep_braces}{Should the braces be kept ?}

\item{keep_pkg_prefix}{Should the package prefix be kept ?}

\item{pkg}{package name}

\item{...}{See \code{\link[bslib:tooltip]{bslib::tooltip()}}}

\item{call}{Function call of the form \code{pkg::fun()}}
}
\value{
\code{\link[=to_pkg]{to_pkg()}} and \code{\link[=to_call]{to_call()}} return text to include in html documents
}
\description{
Setup automatic linking
}
\examples{

\dontrun{
  # auto is mostly meant to be called inside rmarkdown or quarto documents
  auto()
  auto(keep_braces = FALSE, keep_pkg_prefix = FALSE)

  # manually generate the tooltips for {pkg} and pkg::fun()
  link::to_pkg("tidyverse")
  link::to_pkg("tidyverse")

  link::to_call("dplyr::summarise()")
  link::to_call("dplyr::summarise()")
}

link::to_pkg("tidyverse", type = "plain")
link::to_call("dplyr::summarise()", type = "plain")

}
