% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseOTB.R
\name{parseOTBAlgorithms}
\alias{parseOTBAlgorithms}
\title{Retrieve available OTB modules}
\usage{
parseOTBAlgorithms(gili = NULL)
}
\arguments{
\item{gili}{optional list of available `OTB` installations, if not specified, 
`linkOTB()` is called to automatically try to find a valid OTB installation}
}
\description{
Read in the selected OTB module folder and create a list of available functions.
}
\examples{
\dontrun{
## link to the OTB binaries
otblink<-link2GI::linkOTB()

 if (otblink$exist) {

 ## parse all modules
 moduleList<-parseOTBAlgorithms(gili = otblink)

 ## print the list
 print(moduleList)
 
 } 
}

}
