% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{centerTime}
\alias{centerTime}
\title{Move the window such that the given time is centered}
\usage{
centerTime(id, time, options)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{time}{The date/time to center around}

\item{options}{Named list of options controlling the animation. Most common
option is \code{"animation" = TRUE/FALSE}. For a full list of options, see
the "moveTo" method in the
\href{https://visjs.github.io/vis-timeline/docs/graph2d/#Methods}{official
graph2d documentation}}
}
\value{
None, side-effect is Javascript call
}
\description{
Move the window such that the given time is centered
}
\examples{
\dontrun{
linevis() \%>\%
  centerTime(Sys.Date() - 1)
}

if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Center around 24 hours ago")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis()
    )
    observeEvent(input$btn, {
      centerTime("graph2d", Sys.Date() - 1)
    })
  }
)
}
}
